#include <unistd.h>
#include <stdio.h>


void
usage(
	void)
{
	fprintf(stderr, "usage: stc TYPE APPL file ...\n");
	exit(1);
}


int
main(
	int argc,
	char **argv)
{
	ulong type;
	ulong creator;
	int ix;

	if (!argv[1] || !argv[2] || !argv[3]) {
		usage();
	}
	if (strlen(argv[1]) != 4 || strlen(argv[2]) != 4) {
		usage();
	}
	memcpy(&type, argv[1], 4);
	memcpy(&creator, argv[2], 4);
	for (ix = 3; ix<argc; ix++)
		if (set_file_type_creator(argv[ix], type, creator))
			fprintf(stderr, "Can't set file %s\n", argv[ix]);
	return 0;
}
